const express = require('express');
const prisma = require('../config/db');
const { authMiddleware, requireRole } = require('../middleware/auth');

const router = express.Router();

router.get('/summary', authMiddleware, requireRole('AGENT'), async (req, res) => {
  try {
    const agentId = req.user.id;

    const [userCount, totalUserBalance, pendingWithdraw] = await Promise.all([
      prisma.user.count({
        where: { role: { name: 'USER' }, agentId },
      }),
      prisma.wallet.aggregate({
        _sum: { balance: true },
        where: { user: { role: { name: 'USER' }, agentId } },
      }),
      prisma.withdrawRequest.count({
        where: {
          status: 'PENDING',
          user: { role: { name: 'USER' }, agentId },
        },
      }),
    ]);

    return res.json({
      usersUnderMe: userCount,
      usersTotalBalance: totalUserBalance._sum.balance || 0,
      pendingWithdrawCount: pendingWithdraw,
    });
  } catch (err) {
    console.error('agent summary error:', err);
    return res.status(500).json({ message: 'Internal server error' });
  }
});

module.exports = router;
