import React, { useState, useEffect } from 'react';
import { Routes, Route, useNavigate } from 'react-router-dom';
import Login from './Login';
import GamePage from './GamePage';

function RequireAuth({ children }) {
  const navigate = useNavigate();
  useEffect(() => {
    const token = localStorage.getItem('gca_user_token');
    if (!token) navigate('/login');
  }, [navigate]);
  return children;
}

function App() {
  const [loggedIn, setLoggedIn] = useState(false);

  useEffect(() => {
    const token = localStorage.getItem('gca_user_token');
    if (token) setLoggedIn(true);
  }, []);

  const handleLogout = () => {
    localStorage.removeItem('gca_user_token');
    localStorage.removeItem('gca_user_user');
    setLoggedIn(false);
  };

  return (
    <Routes>
      <Route
        path="/login"
        element={<Login onLoggedIn={() => setLoggedIn(true)} />}
      />
      <Route
        path="/game"
        element={
          <RequireAuth>
            <GamePage onLogout={handleLogout} />
          </RequireAuth>
        }
      />
      <Route
        path="*"
        element={loggedIn ? <GamePage onLogout={handleLogout} /> : <Login onLoggedIn={() => setLoggedIn(true)} />}
      />
    </Routes>
  );
}

export default App;
