import React, { useEffect, useState } from 'react';
import api from './api_client';

function Dashboard({ onLogout }) {
  const [summary, setSummary] = useState(null);
  const [error, setError] = useState('');

  useEffect(() => {
    const load = async () => {
      try {
        const res = await api.get('/api/admin/summary');
        setSummary(res.data);
      } catch (err) {
        setError(err.response?.data?.message || 'Failed to load summary');
      }
    };
    load();
  }, []);

  return (
    <div className="layout-main">
      <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <div>
          <h1 className="page-title">SuperAdmin Dashboard</h1>
          <p className="page-sub">Phase 2 • Golden overview of agents, users & coins</p>
        </div>
        <button
          onClick={onLogout}
          style={{
            padding: '8px 14px',
            borderRadius: 999,
            border: '1px solid rgba(255,255,255,0.4)',
            background: 'transparent',
            color: '#f8f5ff',
            cursor: 'pointer',
            fontSize: 12,
          }}
        >
          🚪 Logout
        </button>
      </div>

      {error && <p style={{ marginTop: 16, color: '#ff4b6e', fontSize: 12 }}>{error}</p>}

      {summary && (
        <div className="stats-grid">
          <div className="stat-card">
            <div className="stat-label">Total Agents (users rows)</div>
            <div className="stat-value">{summary.agents}</div>
          </div>
          <div className="stat-card">
            <div className="stat-label">Total Wallets</div>
            <div className="stat-value">{summary.users}</div>
          </div>
          <div className="stat-card">
            <div className="stat-label">Total Turnover</div>
            <div className="stat-value">₹ {summary.totalTurnover}</div>
          </div>
          <div className="stat-card">
            <div className="stat-label">Total Withdraw</div>
            <div className="stat-value">₹ {summary.totalWithdraw}</div>
          </div>
        </div>
      )}
    </div>
  );
}

export default Dashboard;
