const express = require('express');
const prisma = require('../config/db');
const { authMiddleware } = require('../middleware/auth');

const router = express.Router();

router.get('/summary', authMiddleware, async (req, res) => {
  try {
    const [agentCount, userCount] = await Promise.all([
      prisma.user.count(),
      prisma.wallet.count(),
    ]);

    return res.json({
      agents: agentCount,
      users: userCount,
      totalTurnover: 0,
      totalWithdraw: 0,
    });
  } catch (err) {
    console.error('admin summary error:', err);
    return res.status(500).json({ message: 'Internal server error' });
  }
});

module.exports = router;
