import React from 'react';

function UserLayout({ children, walletBalance, onLogout }) {
  return (
    <div className="app-root">
      <div className="layout-main" style={{ maxWidth: 960, margin: '0 auto' }}>
        <header style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', marginBottom: 12 }}>
          <div>
            <h1 className="page-title">Green Color Game</h1>
            <p className="page-sub">Royal / Golden User Panel</p>
          </div>
          <div style={{ display: 'flex', alignItems: 'center', gap: 8 }}>
            <div
              style={{
                borderRadius: 999,
                border: '1px solid rgba(246,214,118,0.6)',
                padding: '6px 10px',
                fontSize: 12,
              }}
            >
              💰 Balance: <span style={{ color: 'var(--gold)' }}>₹ {walletBalance}</span>
            </div>
            <button
              onClick={onLogout}
              style={{
                padding: '6px 12px',
                borderRadius: 999,
                border: '1px solid rgba(255,255,255,0.4)',
                background: 'transparent',
                color: '#f8f5ff',
                cursor: 'pointer',
                fontSize: 12,
              }}
            >
              🚪 Logout
            </button>
          </div>
        </header>
        {children}
      </div>
    </div>
  );
}

export default UserLayout;
